pre{
	'This is the minimal example for the problem with permutation of Collection items.'.println();
	
	var g_number_left_pbDep = Left!ProblemBearing.all.size();
	("Number of <<ProblemBearing>> Dependencies in left model: "+g_number_left_pbDep).println();

	var g_number_right_pbDep = Right!ProblemBearing.all.size();
	("Number of <<ProblemBearing>> Dependencies in right model: "+g_number_right_pbDep).println();
    
    var g_ps_collection       : OrderedSet;
	var g_pbs_collection_left : Sequence;
	var g_pbs_collection_right: Sequence;
   
    // Count all left pattern <<ProblemBearing>> dependencies that have a supplier of the same type:
   	var gt_left_pbDep = Left!Dependency.all();
   	
   	var g_number_supplier_operation_left = determineNumOfPBDSupplierOfType("Operation", gt_left_pbDep);
 	("Number Operation supplier type in left PCP: "+g_number_supplier_operation_left).println();
	g_pbs_collection_left = addPBDSupplierOfType("Operation", gt_left_pbDep, g_pbs_collection_left);
	
	var g_number_supplier_property_left = determineNumOfPBDSupplierOfType("Property", gt_left_pbDep);
  	("Number Property supplier type in left PCP: "+g_number_supplier_property_left).println();
  	g_pbs_collection_left = addPBDSupplierOfType("Property", gt_left_pbDep, g_pbs_collection_left);
  	
  	var g_number_supplier_class_left = determineNumOfPBDSupplierOfType("Class", gt_left_pbDep);
  	("Number Class supplier type in left PCP: "+g_number_supplier_class_left).println();
    g_pbs_collection_left = addPBDSupplierOfType("Class", gt_left_pbDep, g_pbs_collection_left);
    
    // Count all left pattern <<ProblemBearing>> dependencies that have a supplier of the same type:
   	var gt_right_pbDep = Right!Dependency.all();
   	var g_number_supplier_operation_right = determineNumOfPBDSupplierOfType("Operation", gt_right_pbDep);
	("Number Operation supplier type in right PCP: "+g_number_supplier_operation_right).println();
	g_pbs_collection_right = addPBDSupplierOfType("Operation", gt_right_pbDep, g_pbs_collection_right);
	
	var g_number_supplier_property_right = determineNumOfPBDSupplierOfType("Property", gt_right_pbDep);
  	("Number Property supplier type in right PCP: "+g_number_supplier_property_right).println();
  	g_pbs_collection_right = addPBDSupplierOfType("Property", gt_right_pbDep, g_pbs_collection_right);                                
  	
  	var g_number_supplier_class_right = determineNumOfPBDSupplierOfType("Class", gt_right_pbDep);
  	("Number Class supplier type in right PCP: "+g_number_supplier_class_right).println();
	g_pbs_collection_right = addPBDSupplierOfType("Class", gt_right_pbDep, g_pbs_collection_right);

	var g_number_of_pbs_nodes_left = 
	     g_number_supplier_property_left
	    +g_number_supplier_operation_left
	    +g_number_supplier_class_left;
	    
	var g_number_of_pbs_nodes_right =    
	     g_number_supplier_property_right
	    +g_number_supplier_operation_right
	    +g_number_supplier_class_right;

   var g_num_of_mapping_elements   : Integer;
   var g_pbs_collection_to_permute : Sequence;
   if (g_number_of_pbs_nodes_left = g_number_of_pbs_nodes_right or
       g_number_of_pbs_nodes_left > g_number_of_pbs_nodes_right){
      g_num_of_mapping_elements = g_number_of_pbs_nodes_left;
      g_pbs_collection_to_permute = g_pbs_collection_left;

   }
   else if (g_number_of_pbs_nodes_left < g_number_of_pbs_nodes_right){
      g_num_of_mapping_elements = g_number_of_pbs_nodes_right;
      g_pbs_collection_to_permute = g_pbs_collection_right;
   }
   
   var g_current_mapping_num : Integer;
   var g_element_in_current_mapping : Integer;

   var g_arrZahlen : Sequence;
   var g_intAnzahl : Integer;
   
   ("g_num_of_mapping_elements: "+g_num_of_mapping_elements).println();   
   g_intAnzahl = g_num_of_mapping_elements;
   g_arrZahlen = g_pbs_collection_to_permute;
   ("This is the list of elements/items in the set/collection that "
    + "need to be permuted: "+g_arrZahlen).println();
   "Start of permutation".println(); 
   nextPermutation(1);	
}
////////////////////////////////////////////////////////////////////////////////
// Determine number of problemBearing dependencies with supplier of a certain
// type 
////////////////////////////////////////////////////////////////////////////////
operation determineNumOfPBDSupplierOfType(
	i_supplierType         : String,
	it_pbDep	           : Collection
	): Integer{
	var l_supplierType = i_supplierType;
	var lt_pbDep       = it_pbDep;
	var l_numOfPBDSupplierType : Integer;
	
	for (l_Dependency in lt_pbDep){
    	if (l_Dependency.hasStereotype("ProblemBearing") = true){
       		// number of <<ProblemBearing>> dependencies with given supplier type
   	   		if (l_Dependency.supplier.first().eClass.name = l_supplierType){
   	      		l_numOfPBDSupplierType = l_numOfPBDSupplierType + 1;
		  		continue;
		  	}
   	   		else if (l_Dependency.supplier.first().eClass.name <>
   	   		                                                    l_supplierType){
   	   			continue;
   	   		}
    	}
   	else if (l_Dependency.hasStereotype("ProblemBearing") = false){
    		continue;
    	}
    }
    return l_numOfPBDSupplierType; 
}
////////////////////////////////////////////////////////////////////////////////
// Adds supplier of <<ProblemBearing>> dependencies of certain type to
// a set for later mapping 
////////////////////////////////////////////////////////////////////////////////
operation addPBDSupplierOfType(
	i_supplierType         : String,
	it_pbDep	           : Collection,
	it_pbs_collection	   : Sequence
	): Sequence{
	var l_supplierType   = i_supplierType;
	var lt_pbDep         = it_pbDep;
	var l_pbs_collection = it_pbs_collection;
	var l_label : String;
	
	for (l_Dependency in lt_pbDep){
    	if (l_Dependency.hasStereotype("ProblemBearing") = true){
       		// number of ProblemBearing dependencies with given supplier type
   	   		if (l_Dependency.supplier.first().eClass.name = l_supplierType){
   	      		if (l_supplierType <> "Class"){
   	      			l_label = l_Dependency.supplier.first().eContainer().name
   	      			+ "." + l_Dependency.supplier.name.concat();
   	      		}
   	      		else if (l_supplierType = "Class"){
   	      			l_label = l_Dependency.supplier.name.concat();
   	      		}
   	      		l_pbs_collection.add(l_label);
		  		continue;
		  	}
   	   		else if (l_Dependency.supplier.first().eClass.name <> l_supplierType){
   	   			continue;
   	   		}
    	}
   	else if (l_Dependency.hasStereotype("ProblemBearing") = false){
    		continue;
    	}
    }
    return l_pbs_collection; 
}
////////////////////////////////////////////////////////////////////////////////
// Check whether a model element has a given stereotype applied 
////////////////////////////////////////////////////////////////////////////////
operation Dependency hasStereotype(name:String):Boolean {
	var lf_HasStereotype = false;
	for (stereotype in self.getAppliedStereotypes()){
		if (stereotype.name = name){
	    	lf_HasStereotype = true;
	    	break;
	    }
	    else if (stereotype.name <> name){
	    	lf_HasStereotype = false;
	    	continue;
	    }
	}
	if (lf_HasStereotype = true){
		return true;
	}
	if (lf_HasStereotype = false){
		return false;
	}
}
////////////////////////////////////////////////////////////////////////////////
// Permutation of all items in a collection 
////////////////////////////////////////////////////////////////////////////////
operation nextPermutation( intI : Integer ){
     var l_intHelp : String;
     var l_i       : Integer;
     // Recursive determination of all permutations of a set of with size intAnzahl
   	 l_i = intI;
     while ( l_i < g_intAnzahl ){
     	// Exchange the current position with the given position
     	l_intHelp = g_arrZahlen.at(l_i);
     	("l_i: "+l_i).println();
     	("l_intHelp: "+l_intHelp).println();
     	("g_arrZahlen.at(l_i): "+g_arrZahlen.at(l_i)).println();
     	("intI: "+intI).println();
     	g_arrZahlen.removeAt(l_i);
     	g_arrZahlen.add(l_i, g_arrZahlen.at(intI));
     	g_arrZahlen.removeAt(intI);
     	g_arrZahlen.add(intI, l_intHelp);
     	
     	// If the end of the set has not been reached
     	if (intI < g_intAnzahl-1){
     		nextPermutation(intI + 1);
     	}
     	else{
     		("Permutation: "+g_arrZahlen).println();
     	}
     	// Reverse the exchange again
     	l_intHelp = g_arrZahlen.at(l_i);
     	g_arrZahlen.removeAt(l_i);
     	g_arrZahlen.add(l_i, g_arrZahlen.at(intI));
     	g_arrZahlen.removeAt(intI);
     	g_arrZahlen.add(intI, l_intHelp);
     	l_i = l_i + 1;
 	}
}
